import 'package:flutter/material.dart';
import 'package:flutter_widget_from_html/flutter_widget_from_html.dart';
import '../../models/custom_pages.dart';

class CustomPagesScreen extends StatefulWidget {
  CustomPagesScreen({
    required this.details,
  });

  final CustomPage details;
  @override
  _CustomPagesScreenState createState() => _CustomPagesScreenState();
}

class _CustomPagesScreenState extends State<CustomPagesScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          backgroundColor: Colors.black,
          title: Text("${widget.details.title}"),
        ),
        body: SingleChildScrollView(
          child: Padding(
            padding:
                EdgeInsets.only(left: 35.0, right: 35.0, top: 20.0, bottom: 35),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(
                  flex: 1,
                  child: HtmlWidget(
                    '${widget.details.detail}',
                  ),
                ),
              ],
            ),
          ),
        ));
  }
}
